// VFS Manager header file

#define sysFileCVFSMgr 'vfsm'

typedef Err (*ExpPollingProcPtr)(UInt16 slotLibRefNum,void *slotPollRefConP);

typedef struct ExpCardInfoTag
{
UInt32 capabilityFlags;
Char manufacturerStr[31 +1];
Char productStr[31 +1];
Char deviceClassStr[31 +1];
Char deviceUniqueIDStr[31 +1];
} ExpCardInfoType;

typedef ExpCardInfoType *ExpCardInfoPtr;

typedef enum {
expInit = 0,
expSlotDriverInstall,
expSlotDriverRemove,
expSlotLibFind,
expSlotRegister,
expSlotUnregister,
expCardInserted,
expCardRemoved,
expCardPresent,
expCardInfo,
expSlotEnumerate,
expMaxSelector = expSlotEnumerate,
expBigSelector = 0x7FFF
} ExpansionMgrSelector;

Err ExpSlotEnumerate(UInt16 *slotRefNumP,UInt32 *slotIteratorP)
= { 0x7400 + expSlotEnumerate, 0x4E40 + 15, sysTrapSysReserved2 } ;

Err ExpCardPresent(UInt16 slotRefNumber)
= { 0x7400 + expCardPresent, 0x4E40 + 15, sysTrapSysReserved2 } ;

Err ExpCardInfo(UInt16 slotRefNumber, ExpCardInfoType* infoP)
= { 0x7400 + expCardInfo, 0x4E40 + 15, sysTrapSysReserved2 } ;

typedef struct VFSAnyMountParamTag {
UInt16 volRefNum;
UInt16 reserved;
UInt32 mountClass;
} VFSAnyMountParamType;

typedef VFSAnyMountParamType *VFSAnyMountParamPtr ;

typedef struct VFSSlotMountParamTag {
VFSAnyMountParamType vfsMountParam;
UInt16 slotLibRefNum;
UInt16 slotRefNum;
} VFSSlotMountParamType;

typedef struct FileInfoTag{
UInt32 attributes;
Char *nameP;
UInt16 nameBufLen;
} FileInfoType;

typedef FileInfoType *FileInfoPtr;

typedef struct VolumeInfoTag{
UInt32 attributes;
UInt32 fsType;
UInt32 fsCreator;
UInt32 mountClass;
UInt16 slotLibRefNum;
UInt16 slotRefNum;
UInt32 mediaType;
UInt32 reserved;
} VolumeInfoType;

typedef VolumeInfoType *VolumeInfoPtr;

typedef UInt32 FileRef;
typedef UInt16 FileOrigin;

typedef enum {
vfsTrapInit = 0,
vfsTrapCustomControl,
vfsTrapFileCreate,
vfsTrapFileOpen,
vfsTrapFileClose,
vfsTrapFileReadData,
vfsTrapFileRead,
vfsTrapFileWrite,
vfsTrapFileDelete,
vfsTrapFileRename,
vfsTrapFileSeek,
vfsTrapFileEOF,
vfsTrapFileTell,
vfsTrapFileResize,
vfsTrapFileAttributesGet,
vfsTrapFileAttributesSet,
vfsTrapFileDateGet,
vfsTrapFileDateSet,
vfsTrapFileSize,
vfsTrapDirCreate,
vfsTrapDirEntryEnumerate,
vfsTrapGetDefaultDirectory,
vfsTrapRegisterDefaultDirectory,
vfsTrapUnregisterDefaultDirectory,
vfsTrapVolumeFormat,
vfsTrapVolumeMount,
vfsTrapVolumeUnmount,
vfsTrapVolumeEnumerate,
vfsTrapVolumeInfo,
vfsTrapVolumeLabelGet,
vfsTrapVolumeLabelSet,
vfsTrapVolumeSize,
vfsTrapInstallFSLib,
vfsTrapRemoveFSLib,
vfsTrapImportDatabaseFromFile,
vfsTrapExportDatabaseToFile,
vfsTrapFileDBGetResource,
vfsTrapFileDBInfo,
vfsTrapFileDBGetRecord,
vfsMaxSelector = vfsTrapFileDBGetRecord,
vfsBigSelector = 0x7FFF
} VFSMgrSelector;

Err VFSFileCreate(UInt16 volRefNum, const Char *pathNameP)
= { 0x7400 + vfsTrapFileCreate, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileOpen(UInt16 volRefNum, const Char *pathNameP,
UInt16 openMode, FileRef *fileRefP)
= { 0x7400 + vfsTrapFileOpen, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileClose(FileRef fileRef)
= { 0x7400 + vfsTrapFileClose, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileReadData(FileRef fileRef, UInt32 numBytes, void *bufBaseP,
UInt32 offset, UInt32 *numBytesReadP)
= { 0x7400 + vfsTrapFileReadData, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileRead(FileRef fileRef, UInt32 numBytes, void *bufP, UInt32 
*numBytesReadP)
= { 0x7400 + vfsTrapFileRead, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileWrite(FileRef fileRef, UInt32 numBytes, const void *dataP, UInt32 
*numBytesWrittenP)
= { 0x7400 + vfsTrapFileWrite, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileDelete(UInt16 volRefNum, const Char *pathNameP)
= { 0x7400 + vfsTrapFileDelete, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileRename(UInt16 volRefNum, const Char *pathNameP, const Char *newNameP)
= { 0x7400 + vfsTrapFileRename, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileSeek(FileRef fileRef, FileOrigin origin, Int32 offset)
= { 0x7400 + vfsTrapFileSeek, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileEOF(FileRef fileRef)
= { 0x7400 + vfsTrapFileEOF, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileTell(FileRef fileRef, UInt32 *filePosP)
= { 0x7400 + vfsTrapFileTell, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileResize(FileRef fileRef, UInt32 newSize)
= { 0x7400 + vfsTrapFileResize, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileAttributesGet(FileRef fileRef, UInt32 *attributesP)
= { 0x7400 + vfsTrapFileAttributesGet, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileAttributesSet(FileRef fileRef, UInt32 attributes)
= { 0x7400 + vfsTrapFileAttributesSet, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileGetDate(FileRef fileRef, UInt16 whichDate, UInt32 *dateP)
= { 0x7400 + vfsTrapFileDateGet, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileSetDate(FileRef fileRef, UInt16 whichDate, UInt32 date)
= { 0x7400 + vfsTrapFileDateSet, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileSize(FileRef fileRef, UInt32 *fileSizeP)
= { 0x7400 + vfsTrapFileSize, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSDirCreate(UInt16 volRefNum, const Char *dirNameP)
= { 0x7400 + vfsTrapDirCreate, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSDirEntryEnumerate(FileRef dirRef, UInt32 *dirEntryIteratorP, 
FileInfoType *infoP)
= { 0x7400 + vfsTrapDirEntryEnumerate, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSVolumeFormat(UInt8 flags, UInt16 fsLibRefNum, VFSAnyMountParamPtr 
vfsMountParamP)
= { 0x7400 + vfsTrapVolumeFormat, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSVolumeEnumerate(UInt16 *volRefNumP, UInt32 *volIteratorP)
= { 0x7400 + vfsTrapVolumeEnumerate, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSVolumeInfo(UInt16 volRefNum, VolumeInfoType *volInfoP)
= { 0x7400 + vfsTrapVolumeInfo, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSVolumeGetLabel(UInt16 volRefNum, Char *labelP, UInt16 bufLen)
= { 0x7400 + vfsTrapVolumeLabelGet, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSVolumeSetLabel(UInt16 volRefNum, const Char *labelP)
= { 0x7400 + vfsTrapVolumeLabelSet, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSVolumeSize(UInt16 volRefNum, UInt32 *volumeUsedP, UInt32 *volumeTotalP)
= { 0x7400 + vfsTrapVolumeSize, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSImportDatabaseFromFile(UInt16 volRefNum, const Char *pathNameP,
UInt16 *cardNoP, LocalID *dbIDP)
= { 0x7400 + vfsTrapImportDatabaseFromFile, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSExportDatabaseToFile(UInt16 volRefNum, const Char *pathNameP,
UInt16 cardNo, LocalID dbID)
= { 0x7400 + vfsTrapExportDatabaseToFile, 0x4E40 + 15, sysTrapSysReserved3 } ;


/*
Err VFSFileDBGetResource(FileRef ref, DmResType type, DmResID resID, MemHandle 
*resHP)
= { 0x7400 + vfsTrapFileDBGetResource, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileDBInfo(FileRef ref, Char *nameP,
UInt16 *attributesP, UInt16 *versionP, UInt32 *crDateP,
UInt32 *modDateP, UInt32 *bckUpDateP,
UInt32 *modNumP, MemHandle *appInfoHP,
MemHandle *sortInfoHP, UInt32 *typeP,
UInt32 *creatorP, UInt16 *numRecordsP)
= { 0x7400 + vfsTrapFileDBInfo, 0x4E40 + 15, sysTrapSysReserved3 } ;

Err VFSFileDBGetRecord(FileRef ref, UInt16 recIndex, MemHandle *recHP,
UInt8 *recAttrP, UInt32 *uniqueIDP)
= { 0x7400 + vfsTrapFileDBGetRecord, 0x4E40 + 15, sysTrapSysReserved3 } ;
*/

/************************************************************
 * File Origin constants: offsets passed to 'seek'
 *************************************************************/

#define vfsOriginBeginning	0	// from the beginning (first data byte of file)
#define vfsOriginCurrent		1	// from the current position
#define vfsOriginEnd		2	// from the end of file (one position beyond last data byte, only negative offsets are legal)


/************************************************************
 * openMode flags passed to VFSFileOpen
 *************************************************************/

#define vfsModeExclusive		(0x0001U)	// don't let anyone else open it
#define vfsModeRead			(0x0002U)	// open for read access
#define vfsModeWrite		(0x0004U | vfsModeExclusive)	// open for write access, implies exclusive
#define vfsModeCreate		(0x0008U)	// create the file if it doesn't already exist.  Implemented in VFS layer
#define vfsModeTruncate		(0x0010U)	// Truncate file to 0 bytes after opening, removing all existing data. Implemented in VFS layer
#define vfsModeReadWrite		(vfsModeWrite | vfsModeRead)	// open for read/write access
#define vfsModeLeaveOpen		(0x0020U)	// Leave the file open even if when the foreground task closes


// Combination flag constants, for error checking purposes:
#define vfsModeAll			(vfsModeExclusive | vfsModeRead | vfsModeWrite | vfsModeCreate | vfsModeTruncate | vfsModeReadWrite | vfsModeLeaveOpen)
#define vfsModeVFSLayerOnly	(vfsModeCreate | vfsModeTruncate)	// flags only used apps & the VFS layer, FS libraries will never see these.


/************************************************************
 * File Attributes
 *************************************************************/

#define vfsFileAttrReadOnly		(0x00000001UL)
#define vfsFileAttrHidden		(0x00000002UL)
#define vfsFileAttrSystem		(0x00000004UL)
#define vfsFileAttrVolumeLabel	(0x00000008UL)
#define vfsFileAttrDirectory		(0x00000010UL)
#define vfsFileAttrArchive		(0x00000020UL)
#define vfsFileAttrLink			(0x00000040UL)
#define vfsFileAttrAll			(0x0000007fUL)


/************************************************************
 * Volume Attributes
 *************************************************************/

#define vfsVolumeAttrSlotBased	(0x00000001UL)		// reserved
#define vfsVolumeAttrReadOnly		(0x00000002UL)		// volume is read only
#define vfsVolumeAttrHidden		(0x00000004UL)		// volume should not be user-visible.

/************************************************************
 * Date constants (for use with VFSFileGet/SetDate)
 *************************************************************/

#define vfsFileDateCreated		1
#define vfsFileDateModified		2
#define vfsFileDateAccessed		3

/************************************************************
 * Iterator start and stop constants.
 * Used by VFSVolumeEnumerate, VFSDirEntryEnumerate, VFSDirEntryEnumerate
 *************************************************************/

#define vfsIteratorStart           0L
#define vfsIteratorStop            0xffffffffL
#define expIteratorStart           0L
#define expIteratorStop            0xffffffffL


/************************************************************
 * 'handled' field bit constants 
 * (for use with Volume Mounted/Unmounted notifications)
 *************************************************************/

#define vfsHandledUIAppSwitch	0x01	// Any UI app switching has already been handled.  
										
// The VFSMgr will not UIAppSwitch to the start.prc app 
// (but it will loaded & sent the AutoStart launchcode), 
// and the Launcher will not switch to itself.

#define vfsHandledStartPrc	0x02	// And automatic running of start.prc has already been handled.
										
// VFSMgr will not load it, send it the AutoStart launchcode,
// or UIAppSwitch to it.

/************************************************************
 * Format/Mount flags (for use with VFSVolumeFormat/Mount)
 *************************************************************/

#define vfsMountFlagsUseThisFileSystem	0x01	// Mount/Format the volume with the filesystem specified
//#define vfsMountFlagsPrivate1		0x02	// for system use only
//#define vfsMountFlagsPrivate2		0x04	// for system use only

#define vfsMountFlagsReserved1		0x08	// reserved
#define vfsMountFlagsReserved2		0x10	// reserved
#define vfsMountFlagsReserved3		0x20	// reserved
#define vfsMountFlagsReserved4		0x40	// reserved
#define vfsMountFlagsReserved5		0x80	// reserved


/************************************************************
 * Common filesystem types.  Used by FSFilesystemType and SlotCardIsFilesystemSupported.
 *************************************************************/

#define vfsFilesystemType_VFAT	'vfat'	// FAT12 and FAT16 extended to handle long file names
#define vfsFilesystemType_FAT		'fats'	// FAT12 and FAT16 which only handles 8.3 file names
#define vfsFilesystemType_NTFS	'ntfs'	// Windows NT filesystem
#define vfsFilesystemType_HFSPlus	'hfse'	// The Macintosh extended hierarchical filesystem
#define vfsFilesystemType_HFS		'hfss'	// The Macintosh standard hierarchical filesystem
#define vfsFilesystemType_MFS		'mfso'	// The Macintosh original filesystem
#define vfsFilesystemType_EXT2	'ext2'	// Linux filesystem
#define vfsFilesystemType_FFS		'ffsb'	// Unix Berkeley block based filesystem
#define vfsFilesystemType_NFS		'nfsu'	// Unix Networked filesystem
#define vfsFilesystemType_AFS		'afsu'	// Unix Andrew filesystem
#define vfsFilesystemType_Novell	'novl'	// Novell filesystem
#define vfsFilesystemType_HPFS	'hpfs'	// OS2 High Performance filesystem


/************************************************************
 * Error codes
 *************************************************************/

#define vfsErrorClass 0x2A00 
#define vfsErrBufferOverflow		(vfsErrorClass | 1)	// passed in buffer is too small
#define vfsErrFileGeneric		(vfsErrorClass | 2) // Generic file error.
#define vfsErrFileBadRef			(vfsErrorClass | 3) // the fileref is invalid (has been closed, or was not obtained from VFSFileOpen())
#define vfsErrFileStillOpen		(vfsErrorClass | 4)	// returned from FSFileDelete if the file is still open
#define vfsErrFilePermissionDenied	(vfsErrorClass | 5)	// The file is read only
#define vfsErrFileAlreadyExists	(vfsErrorClass | 6)	// a file of this name exists already in this location
#define vfsErrFileEOF			(vfsErrorClass | 7) // file pointer is at end of file
#define vfsErrFileNotFound		(vfsErrorClass | 8) // file was not found at the path specified
#define vfsErrVolumeBadRef		(vfsErrorClass | 9) // the volume refnum is invalid.
#define vfsErrVolumeStillMounted	(vfsErrorClass | 10) // returned from FSVolumeFormat if the volume is still mounted
#define vfsErrNoFileSystem		(vfsErrorClass | 11) // no installed filesystem supports this operation
#define vfsErrBadData			(vfsErrorClass | 12) // operation could not be completed because of invalid data (i.e., import DB from .PRC file)
#define vfsErrDirNotEmpty		(vfsErrorClass | 13) // can't delete a non-empty directory
#define vfsErrBadName			(vfsErrorClass | 14) // invalid filename, or path, or volume label or something...
#define vfsErrVolumeFull			(vfsErrorClass | 15) // not enough space left on volume
#define vfsErrUnimplemented		(vfsErrorClass | 16) // this call is not implemented
#define vfsErrNotADirectory		(vfsErrorClass | 17) // This operation requires a directory
#define vfsErrIsADirectory         (vfsErrorClass | 18) // This operation requires a regular file, not a directory
#define vfsErrDirectoryNotFound	(vfsErrorClass | 19) // Returned from VFSFileCreate when the path leading up to the new file does not exist
#define vfsErrNameShortened		(vfsErrorClass | 20) // A volume name or filename was automatically shortened to conform to filesystem spec

